% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{contingency}
\alias{contingency}
\title{Measures of association from two by two contingency tables (formula).}
\usage{
contingency(
  object = NULL,
  formula = NULL,
  data = NULL,
  method = "cohort.count",
  ...
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: outcome ~ exposure.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{method}{A character string with options: "cohort.count", "cohort.time", "case.control", or "cross.sectional".}

\item{...}{Further arguments passed to \code{epi.2by2}.}
}
\description{
\code{contingency} is a wrap that calls \code{epi.2by2} from package \code{epiR}.
}
\details{
\code{contingency} uses a formula as a way to input variables.

\code{contingency} displays the contingency table as a way for the user to check that the reference levels
in the categorical variables (outcome and exposure) are correct. Then displays measures of association
(table from \code{epi.2by2}). It also reports either chi-squared
test or exact Fisher's test;
\code{contingency} checks which one of the tests two is appropriate.
}
\examples{
## A case-control study on the effect of alcohol on oesophageal cancer.
Freq <- c(386, 29, 389, 171)
status <- gl(2, 1, 4, labels = c("Control", "Case"))
alcohol <- gl(2, 2, labels = c("0-39", "40+"))
cancer <- data.frame(Freq, status, alcohol)
cancer <- expand_df(cancer)
contingency(status ~ alcohol, data = cancer, method = "case.control")

data(Oncho)
require(dplyr, quietly = TRUE)

Oncho |>
  select(mf, area) |>
  cross_tbl(by = "mf") |>
  theme_pubh(2)

Oncho |>
  contingency(mf ~ area)
}
\seealso{
\code{\link[epiR]{epi.2by2}}.
}
