% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{Vanderpump}
\alias{Vanderpump}
\title{Smoking and mortality in Whickham, England.}
\format{A labelled tibble with 1314 rows and 3 variables:
\describe{
\item{vstatus}{Vitality status, factor with levels "Alive" and "Death".}
\item{smoker}{Smoking status, factor with levels "Non-smoker" and "Smoker".}
\item{agegrp}{Age group, factor with levels "18-44", "45-64" and "64+".}
}}
\source{
Vanderpump, MP, et al (1996) Thyroid, 6:155-160.

Appleton, DR, French, JM and Vanderpump, PJ (1996) Ignoring a covariate:
An example of Simpson's paradox. The American Statistician 50:340-341.

Vittinghoff, E, Glidden, DV, Shiboski, SC and McCulloh, CE (2005) Regression methods in
Biostatistics. Springer.
}
\usage{
Vanderpump
}
\description{
Data represents women participating in a health survey in Whickham, England in 1972-1974.
}
\examples{
data(Vanderpump)
require(moonBook)

mytable(vstatus ~ smoker, data = Vanderpump, show.total = TRUE)

mytable(vstatus + smoker ~ agegrp, data = Vanderpump, show.total = TRUE)

mhor(vstatus ~ agegrp/smoker, data = Vanderpump)
}
\keyword{datasets}
