% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{coef_plot}
\alias{coef_plot}
\title{Plot of model coefficients.}
\usage{
coef_plot(model, labels = NULL, Exp = FALSE, CI = 0.95, pch = 20,
  col = 1, rotx = 45, ...)
}
\arguments{
\item{model}{A regression object (like \link{glm}).}

\item{labels}{Vector for the coefficient's names (intercept/constant should be omitted).}

\item{Exp}{Logical, should estimates and confidence intervals be exponentiated?}

\item{CI}{Proportion representing the confidence intervals.}

\item{pch}{Point character passed to \link{xyplot}.}

\item{col}{Colour passed to \link{xyplot}.}

\item{rotx}{Degrees to rotate x-labels.}

\item{...}{Further arguments passed to \link{xyplot}.}
}
\description{
\code{coef_plot} Constructs plot displaying estimates of parameters with bars representing confidence intervals.
}
\details{
\code{coef_plot} does not show estimate for the constant (intercept). Estimates and confidence intervals
can be optionally exponentiated, in which case estimates would represent ratios instead of differences.
}
\examples{
data(birthwt, package = "MASS")
birthwt$smoke <- factor(birthwt$smoke, labels=c("Non-smoker", "Smoker"))
birthwt$race <- factor(birthwt$race > 1, labels=c("White", "Non-white"))
model1 <- glm(bwt ~ smoke + race, data = birthwt)
glm_coef(model1, labels=c("Constant", "Smoker vs Non-smoker", "Non-white vs White"))
coef_plot(model1)
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
