% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_functions.R
\name{ss_jk}
\alias{ss_jk}
\title{Sum of squares for Jackknife.}
\usage{
ss_jk(obs, stat)
}
\arguments{
\item{obs}{A numerical vector with no missing values (NA's).}

\item{stat}{The value of the statistic that is used as a reference.}
}
\value{
The squared difference between a variable and a given value.
}
\description{
\code{ss_jk} is an internal function called by \link{jack_knife}. It calculates the squared
difference of a numerical variable around a given value (for example, the mean).
}
\examples{
x <- rnorm(10, 170, 8)
x
mean(x)
ss_jk(x, mean(x))
jack_knife(x)
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
