% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epi_functions.R
\name{diag_test}
\alias{diag_test}
\title{Diagnostic tests from variables.}
\usage{
diag_test(formula, data, ...)
}
\arguments{
\item{formula}{A formula of the form outcome ~ predictor (see details).}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{...}{Further arguments passed to \link{epi.tests}.}
}
\description{
\code{diag_test} is a wrap function that calls \link{epi.tests} from package \code{epiR}.
It computes sensitivity, specificity and other statistics related with screening tests.
}
\details{
For the \code{formula}, the outcome is the gold standard and the explanatory variable is the new (screening) test. See examples.
}
\examples{
## We compare the use of lung’s X-rays on the screening of TB against the gold standard test.
Freq <- c(1739, 8, 51, 22)
BCG <- gl(2, 1, 4, labels=c("Negative", "Positive"))
Xray <- gl(2, 2, labels=c("Negative", "Positive"))
tb <- data.frame(Freq, BCG, Xray)
tb <- expand_df(tb)
diag_test(BCG ~ Xray, data=tb)
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Mark Stevenson, Faculty of Veterinary and Agricultural Sciences, The University of Melbourne, Australia.
}
