% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sp_features.R
\name{kern_xy}
\alias{kern_xy}
\title{Kernel density of nearby areas}
\usage{
kern_xy(base, feat, bandwidth, weight = 1)
}
\arguments{
\item{base}{base dataset (eg gridcells), needs to be SpatialPolygonsDataFrame or SpatialPointsDataFrame}

\item{feat}{feature dataset (eg another crime generator), needs to be SpatialPointsDataFrame}

\item{bandwidth}{scaler bandwidth for the normal KDE}

\item{weight}{if 1 (default), does not use weights, else pass in string that is the variable name for weights in \code{feat}}
}
\value{
A vector of densities (or weighted densities)
}
\description{
Given a base X/Y dataset, calculates guassian kernel density for nearby points in feat dataset
}
\details{
This generates a density of nearby features at particular control points (specified by \code{base}). Useful for risk terrain
style feature engineering given nearby crime generators. Loops through all pairwise distances (and uses \code{dnorm()}). So will be slow
for large base + feature datasets (although should be OK memory wise). Consider aggregating/weighting data if \code{feat} is very large.
}
\examples{
data(nyc_cafe); data(nyc_bor)
gr_nyc <- prep_grid(nyc_bor,6000)
gr_nyc$kdecafe_5k <- kern_xy(gr_nyc,nyc_cafe,8000)
head(gr_nyc@data)
\donttest{
sp::spplot(gr_nyc,zcol='kdecafe_5k')
}

}
\references{
Caplan, J. M., Kennedy, L. W., & Miller, J. (2011). Risk terrain modeling: Brokering criminological theory and GIS methods for crime forecasting. \emph{Justice Quarterly}, 28(2), 360-381.

Wheeler, A. P., & Steenbeek, W. (2021). Mapping the risk terrain for crime using machine learning. \emph{Journal of Quantitative Criminology}, 37(2), 445-480.
}
\seealso{
\code{\link[=dist_xy]{dist_xy()}} for calculating distance to nearest

\code{\link[=count_xy]{count_xy()}} for counting points inside polygon

\code{\link[=kern_xy]{kern_xy()}} for estimating gaussian density of points for features at base polygon xy coords

\code{\link[=bisq_xy]{bisq_xy()}} to estimate bi-square kernel weights of points for features at base polygon xy coords

\code{\link[=idw_xy]{idw_xy()}} to estimate inverse distance weights of points for features at base polygon xy coords
}
