% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa.R
\name{aa.comp}
\alias{aa.comp}
\title{Amino Acid Composition}
\usage{
aa.comp(target, uniprot = TRUE, reference = 'human', init = FALSE)
}
\arguments{
\item{target}{a character string specifying the UniProt ID of the protein of interest or, alternatively, the sequence of that protein.}

\item{uniprot}{logical, if TRUE the argument 'target' should be an ID.}

\item{reference}{amino acid frequencies (in percent) of the proteinogenic amino acids to be used as reference. It should be either 'human', 'up' (composition of proteins in UniProt in 2019). Alternatively, the user can pass as argument any vector with 20 values to be used as reference.}

\item{init}{logical, whether remove or not the first residue (initiation methionine) from the sequence.}
}
\value{
Returns a list where the first element is a dataframe with the observed and expected frequencies for each amino acid, the second element is the result of the Chi-squared test. In addition, a plot to reflect potential deviations from the reference standard composition is shown.
}
\description{
Returns a table with the amino acid composition of the target protein.
}
\examples{
aa.comp('MPSSVSWGILLLAGLCCLVPVSLAEDPQGDAAQK', uniprot = FALSE)
}
\seealso{
is.at(), renum.pdb(), renum.meto(), renum(), aa.at()
}
\author{
Juan Carlos Aledo
}
