% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa.R
\name{renum}
\alias{renum}
\title{Renumerate Residue Position}
\usage{
renum(up_id, pos, from, to, ...)
}
\arguments{
\item{up_id}{the UniProt ID.}

\item{pos}{position in the initial sequence.}

\item{from}{origin of the initial sequence, it should be one among 'uniprot', 'metosite' and 'pdb'.}

\item{to}{target sequence, it should be one among 'uniprot', 'metosite' and 'pdb'.}

\item{...}{additional arguments (PDB ID and chain) when 'pdb' is either origin or destination.}
}
\value{
Returns the final position.
}
\description{
Renumerates residue position.
}
\details{
Either the origin sequence or the target sequence should be uniprot. Nevertheless, the conversion pdb -> metosite, for instance, can be achieved through the path: pdb -> uniprot -> metosite. If 'pdb' is selected, then the PDB ID and the involved chain must be provided, in that order.
}
\examples{
renum(up_id = 'P01009', pos = 351, from = 'metosite', to = 'uniprot')
\dontrun{renum(up_id = 'P01009', pos = 60, from = 'uniprot',
                         to = 'pdb', pdb = '1ATU', chain = 'A')}
}
\seealso{
is.at(), aa.at(), renum.pdb(), renum.meto(), aa.comp()
}
\author{
Juan Carlos Aledo
}
