% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdb_ancillary.R
\name{pdb.select}
\alias{pdb.select}
\title{Select the PDB with the Optimal Coverage to the UniProt Sequence}
\usage{
pdb.select(up_id, threshold = 0.9)
}
\arguments{
\item{up_id}{the UniProt ID.}

\item{threshold}{coverage value that when reached the search is halted.}
}
\value{
A list of two elements: (i) the PDB ID and (ii) the chain. The coverage with the UniProt sequence is given as an attribute.
}
\description{
Select the PDB and chain with the optimal coverage to a given UniProt sequence.
}
\examples{
\dontrun{pdb.select('P01009', threshold = 0.8)}
}
\seealso{
pdb.quaternary(), pdb.chain(), pdb.res(), pdb.pep(), uniprot2pdb(), pdb2uniprot()
}
\author{
Juan Carlos Aledo
}
