% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pFisherg.R
\name{pFisherg}
\alias{pFisherg}
\title{The cumulative distribution function for Fisher'g}
\usage{
pFisherg(g, n, method = c("exact", "RSR"))
}
\arguments{
\item{g}{Fisher'g statistic.}

\item{n}{length of the series.}

\item{method}{method to compute the distribution function.}
}
\value{
the distribution function.
}
\description{
Compute the the cumulative distribution function for Fisher'g
from the selected method. See details.
}
\details{
method provides the following choices:

\code{exact}: Use the exact distribution.

\code{RSR}: Distribution fitted by the response surface regression method.
}
\examples{
#Given the Fisher's g statistic, find the cumulative probability
pFisherg(g=0.3,n=10, method = "exact")
pFisherg(g=0.3,n=10, method = "RSR")

}
\author{
Yuanhao
}
\references{
Fisher, R.A. (1929). Tests of significance in harmonic analysis. 
Proc. Roy. Soc. A, 125, 54-59. 

MacKinnon, James (2001) : Computing numerical distribution functions in 
econometrics, Queen's Economics Department Working Paper, No. 1037.
}
\seealso{
\code{\link{ptestg}}
}
\keyword{internal}

