% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetTDryBulbFromMoistAirVolumeAndHumRatio}
\alias{GetTDryBulbFromMoistAirVolumeAndHumRatio}
\title{Return dry-bulb temperature given moist air specific volume, humidity ratio, and pressure.}
\usage{
GetTDryBulbFromMoistAirVolumeAndHumRatio(MoistAirVolume, HumRatio, Pressure)
}
\arguments{
\item{MoistAirVolume}{A numeric vector of specific volume of moist air in ft3 lb-1 of dry air [IP] or in m3 kg-1 of dry air [SI]}

\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of tDryBulb : Dry-bulb temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return dry-bulb temperature given moist air specific volume, humidity ratio, and pressure.
}
\note{
\itemize{
  \item In IP units, R_DA_IP / 144 equals 0.370486 which is the coefficient appearing in eqn 26.
  \item The factor 144 is for the conversion of Psi = lb in-2 to lb ft-2.
  \item Based on the `GetMoistAirVolume` function, rearranged for dry-bulb temperature.
}
}
\examples{
SetUnitSystem("IP")
GetTDryBulbFromMoistAirVolumeAndHumRatio(14.72, seq(0.02, 0.03, 0.001), 14.175)

SetUnitSystem("SI")
GetTDryBulbFromMoistAirVolumeAndHumRatio(0.94, seq(0.02, 0.03, 0.001), 95461)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1 eqn 26
}
