% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{find_best_model.lavaan}
\alias{find_best_model.lavaan}
\title{Returns all combinations of lavaan models with their indices of fit.}
\usage{
\method{find_best_model}{lavaan}(fit, latent = "", samples = 1000,
  verbose = FALSE, ...)
}
\arguments{
\item{fit}{A lavaan object.}

\item{latent}{Copy/paste the part related to latent variables loadings.}

\item{samples}{Number of random draws.}

\item{verbose}{Show progress.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
list containing all combinations.
}
\description{
Returns all combinations of lavaan models with their indices of fit.
}
\examples{
library(psycho)
library(lavaan)

model <- " visual  =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed   =~ x7 + x8 + x9
visual ~ textual
textual ~ speed"
fit <- lavaan::sem(model, data = HolzingerSwineford1939)

models <- find_best_model(fit, latent = "visual  =~ x1 + x2 + x3
textual =~ x4 + x5 + x6
speed   =~ x7 + x8 + x9")
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
