% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{analyze.glm}
\alias{analyze.glm}
\title{Analyze glm objects.}
\usage{
\method{analyze}{glm}(x, CI = 95, effsize_rules = "cohen1988", ...)
}
\arguments{
\item{x}{glm object.}

\item{CI}{Confidence interval bounds. Set to NULL turn off their computation.}

\item{effsize_rules}{Grid for effect size interpretation. See \link[=interpret_odds]{interpret_odds}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
output
}
\description{
Analyze glm objects.
}
\examples{
library(psycho)
fit <- glm(Sex ~ Adjusting, data = psycho::affective, family = "binomial")

results <- analyze(fit)
summary(results)
print(results)
}
\references{
Nakagawa, S., & Schielzeth, H. (2013). A general and simple method for obtaining R2 from generalized linear mixed-effects models. Methods in Ecology and Evolution, 4(2), 133-142.
}
\seealso{
\link[=get_R2.glm]{"get_R2.glm"}
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
