% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{create_intervals}
\alias{create_intervals}
\title{Overlap of Two Empirical Distributions.}
\usage{
create_intervals(x, n = NULL, length = NULL, equal_range = TRUE,
  labels = NULL, dig.lab = 3)
}
\arguments{
\item{x}{A vector of numerics.}

\item{n}{Number of intervals to create, OR}

\item{length}{Length of each interval.}

\item{equal_range}{Makes n groups with with equal range (TRUE) or (approximately) equal numbers of observations (FALSE).}

\item{labels}{Can be a custom list, "NULL", "FALSE" or "median".}

\item{dig.lab}{Integer which is used when labels are not given. It determines the number of digits used in formatting the break numbers.}
}
\description{
A method to calculate the overlap coefficient of two kernel density estimates (a measure of similarity between two samples).
}
\examples{
library(psycho)

x <- rnorm(100, 0, 1)

create_intervals(x, n = 4)
create_intervals(x, n = 4, equal_range = FALSE)
create_intervals(x, length = 1)

create_intervals(x, n = 4, labels = "median")
create_intervals(x, n = 4, labels = FALSE)
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
