% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret_odds.R
\name{interpret_odds}
\alias{interpret_odds}
\title{Omega Squared Interpretation}
\usage{
interpret_odds(x, log = FALSE, direction = FALSE, rules = "chen2010")
}
\arguments{
\item{x}{Odds ratio.}

\item{log}{Are these log odds ratio?}

\item{direction}{Return direction.}

\item{rules}{Can be "chen2010" (default), "cohen1988" (through \link[=odds_to_d]{log odds to Cohen's d transformation}) or a custom list.}
}
\description{
Return the interpretation of Omegas Squared.
}
\examples{
library(psycho)
interpret_odds(x=2)

}
\references{
\itemize{
 \item{Chen, H., Cohen, P., & Chen, S. (2010). How big is a big odds ratio? Interpreting the magnitudes of odds ratios in epidemiological studies. Communications in Statistics—Simulation and Computation®, 39(4), 860-864.}
 }
}
\seealso{
http://imaging.mrc-cbu.cam.ac.uk/statswiki/FAQ/effectSize
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
