% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.fa.R
\name{get_cfa_model}
\alias{get_cfa_model}
\title{Get CFA model.}
\usage{
get_cfa_model(loadings, treshold = "max")
}
\arguments{
\item{loadings}{Formatted loadings.}

\item{treshold}{'max' or numeric. The treshold over which to associate an item with its component.}
}
\description{
Get CFA model.
}
\examples{
\dontrun{
library(psycho)

x <- psych::fa(psych::Thurstone.33, 2)
loadings <- format_loadings(x)$loadings
get_cfa_model(loadings, treshold="max")
get_cfa_model(loadings, treshold=0.1)
}


}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
