% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlation}
\alias{correlation}
\title{Multiple Correlations.}
\usage{
correlation(df, df2 = NULL, type = "full", method = "pearson",
  adjust = "holm")
}
\arguments{
\item{df}{The dataframe}

\item{df2}{Optional dataframe to correlate with the first one.}

\item{type}{A character string indicating which correlation type is to be
computed. One of "full" (default), "partial" (partial correlations),
"semi" (semi-partial correlations), "glasso"
(Graphical lasso- estimation of Gaussian graphical models) or "cor_auto"
(will use the qgraph::cor_auto function to return pychoric or polyserial
correlations if needed).}

\item{method}{A character string indicating which correlation coefficient is
to be computed. One of "pearson" (default), "kendall", or "spearman" can be
abbreviated.}

\item{adjust}{What adjustment for multiple tests should be used? ("holm",
"hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none"). See
\link[stats]{p.adjust} for details about why to use "holm" rather than
"bonferroni").}
}
\value{
output
}
\description{
Compute different kinds of correlation matrices.
}
\examples{
df <- attitude

# Normal correlations
results <- psycho::correlation(df)
print(results)
plot(results)

# Partial correlations with correction
results <- psycho::correlation(df, type="partial",
                                   method="spearman",
                                   adjust="holm")
print(results)
plot(results)

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
