% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_r.R
\name{correct_r_split}
\alias{correct_r_split}
\title{Correct correlations for uneven/unrepresentative splits}
\usage{
correct_r_split(r, pi, pa = 0.5, n = NULL)
}
\arguments{
\item{r}{Vector of correlations affected by an uneven or unrepresentative split of a dichotomous variable.}

\item{pi}{Vector of proportions of incumbent/sample cases in one of the categories of the dichotomous variable.}

\item{pa}{Vector of proportions of applicant/population cases in one of the categories of the dichotomous variable.}

\item{n}{Optional vector of sample sizes.}
}
\value{
Vector of correlations corrected for unrepresentative splits (if \code{n} is supplied, corrected error variance and adjusted sample size is also reported).
}
\description{
\loadmathjax
This correction is mathematically equivalent to correcting the correlation for direct range restriction in the split variable.
}
\details{
\mjdeqn{r_{c}=\frac{r_{obs}}{u\sqrt{\left(\frac{1}{u^{2}}-1\right)r_{obs}^{2}+1}}}{r_c = r / (sqrt((pi*(1-pi))/(pa*(1-pa))) * sqrt(((pa*(1-pa))/(pi*(1-pi)) - 1) * r^2 + 1))}
where \mjeqn{u=\sqrt{\frac{p_{i}(1-p_{i})}{p_{a}(1-p_{a})}}}{sqrt((pi*(1-pi))/(pa*(1-pa)))}, the ratio of the dichotomous variance in the sample (\mjeqn{p_{i}}{pi} is the incumbent/sample proportion in one of the two groups) to the dichotomous variance in the population (\mjeqn{p_{a}}{pa} is the applicant/population proportion in one of the two groups).
This correction is identical to the correction for univariate direct range restriction, applied to a dichotomous variable.
}
\examples{
correct_r_split(r = 0.3, pi = .9, pa = .5, n = 100)
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Sage. \doi{10.4135/9781483398105}. pp. 287-288.
}
