% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_r.R
\name{simulate_r_sample}
\alias{simulate_r_sample}
\title{Simulation of data with measurement error and range-restriction artifacts}
\usage{
simulate_r_sample(
  n,
  rho_mat,
  rel_vec = rep(1, ncol(rho_mat)),
  mu_vec = rep(0, ncol(rho_mat)),
  sigma_vec = rep(1, ncol(rho_mat)),
  sr_vec = rep(1, ncol(rho_mat)),
  k_items_vec = rep(1, ncol(rho_mat)),
  wt_mat = NULL,
  sr_composites = NULL,
  var_names = NULL,
  composite_names = NULL,
  n_as_ni = FALSE,
  ...
)
}
\arguments{
\item{n}{Number of cases to simulate before performing selection. If \code{Inf}, function will simulate parameter values.}

\item{rho_mat}{Matrix of true-score correlations.}

\item{rel_vec}{Vector of reliabilities corresponding to the variables in \code{rho_mat.}}

\item{mu_vec}{Vector of means.}

\item{sigma_vec}{Vector of observed-score standard deviations.}

\item{sr_vec}{Vector of selection ratios corresponding to the variables in \code{rho_mat}
(set selection ratios to 1 for variables that should not be used in selection).}

\item{k_items_vec}{Number of test items comprising each of the variables to be simulated (all are single-item variables by default).}

\item{wt_mat}{Optional matrix of weights to use in forming a composite of the variables in \code{rho_mat.} Matrix should have as many rows (or vector elements) as there are variables in \code{rho_mat}.}

\item{sr_composites}{Optional vector selection ratios for composite variables. If not \code{NULL}, \code{sr_composites} must have as many elements as there are columns in \code{wt_mat}.}

\item{var_names}{Vector of variable names corresponding to the variables in \code{rho_mat}.}

\item{composite_names}{Optional vector of names for composite variables.}

\item{n_as_ni}{Logical argument determining whether n specifies the incumbent sample size (TRUE) or the applicant sample size (FALSE; default). This can only be TRUE when only one variable is involved in selection.}

\item{...}{Further arguments.}
}
\value{
A list of study information, including correlations, reliabilities, standard deviations, means, and \emph{u} ratios for true scores and for observed scores.
}
\description{
This function simulates a psychometric sample and produces correlation matrices, artifact information, and other descriptive statistics that have been affected by measurement error and/or range restriction.
It allows the formation of composite variables within the simulation and allows selection to be performed on any or all variables, including composites.
By setting the sample size to \code{n = Inf}, users can explore the effects of measurement error and/or range restriction on parameters without the influence of sampling error.
To generate multiple samples and compile a database of simulated statistics, see the \code{\link{simulate_r_database}} function.
}
\examples{
\dontrun{
## Generate data for a simple sample with two variables:
simulate_r_sample(n = 1000, rho_mat = matrix(c(1, .5, .5, 1), 2, 2),
          rel_vec = c(.8, .8), sr_vec = c(1, .5), var_names = c("Y", "X"))

## Generate data for samples with five variables, of which subsets are used to form composites:
rho_mat <- matrix(.5, 5, 5)
diag(rho_mat) <- 1

## Simulate parameters by supply n = Inf
simulate_r_sample(n = Inf, rho_mat = rho_mat,
                rel_vec = rep(.8, 5), sr_vec = c(1, 1, 1, 1, .5),
                wt_mat = cbind(c(0, 0, 0, .3, 1), c(1, .3, 0, 0, 0)), sr_composites = c(.7, .5))

## Finite sample sizes allow the generation of sample data
simulate_r_sample(n = 1000, rho_mat = rho_mat,
                rel_vec = rep(.8, 5), sr_vec = c(1, 1, 1, 1, .5),
                wt_mat = cbind(c(0, 0, 0, .3, 1), c(1, .3, 0, 0, 0)), sr_composites = c(.7, .5))
}                 
}
\keyword{datagen}
