% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_r_order2.R
\name{ma_r_order2}
\alias{ma_r_order2}
\title{Second-order meta-analysis function for correlations}
\usage{
ma_r_order2(k, N = NULL, r = NULL, rho = NULL, var_r = NULL,
  var_r_c = NULL, ma_type = c("bb", "ic", "ad"), sample_id = NULL,
  citekey = NULL, moderators = NULL, moderator_type = "simple",
  construct_x = NULL, construct_y = NULL, construct_order = NULL,
  data = NULL, control = control_psychmeta(), ...)
}
\arguments{
\item{k}{Vector or column name of meta-analyses' k values.}

\item{N}{Vector or column name of meta-analyses' total sample sizes (optional).}

\item{r}{Vector or column name of mean observed correlations.}

\item{rho}{Vector or column name of mean corrected correlations.}

\item{var_r}{Vector or column name of observed variances of observed correlations.}

\item{var_r_c}{Vector or column name of observed variances of corrected correlations.}

\item{ma_type}{Type of meta-analyses being analyzed: "bb" (barebones), "ic" (individual correction), or "ad" (artifact distribution).}

\item{sample_id}{Vector or column name of study ID labels.}

\item{citekey}{Optional vector of bibliographic citation keys for samples/studies in the meta-analysis (if multiple citekeys pertain to a given effect size, combine them into a single string entry with comma delimiters (e.g., "citkey1,citekey2").}

\item{moderators}{Matrix or column names of moderator variables to be used in the meta-analysis (can be a vector in the case of one moderator).}

\item{moderator_type}{Type of moderator analysis ("none", "simple", or "hierarchical").}

\item{construct_x}{Vector or column name of construct names for X.}

\item{construct_y}{Vector or column name of construct names for Y.}

\item{construct_order}{Vector indicating the order in which variables should be arranged, with variables listed earlier in the vector being preferred for designation as X.}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments and/or moderators.}

\item{control}{Output from the \code{control_psychmeta()} function or a list of arguments controlled by the \code{control_psychmeta()} function. Ellipsis arguments will be screened for internal inclusion in \code{control}.}

\item{...}{Further arguments to be passed to functions called within the meta-analysis.}
}
\value{
A nested tabular object of the class "ma_psychmeta".
}
\description{
This function computes second-order meta-analysis function for correlations. It supports second-order analyses of bare-bones, artifact-distribution, and individual-correction meta-analyses.
}
\examples{
## Analysis of the validity of conscientiousness as a predictor of job performance in East Asia
out <- ma_r_order2(k = k, r = r_bar_i, rho = rho_bar_i, var_r = var_r,
                   var_r_c = NULL, ma_type = c("bb", "ad"),
                   sample_id = NULL, moderators = NULL,
                   construct_x = NULL, construct_y = NULL,
                   data = dplyr::filter(data_r_oh_2009, Predictor == "Conscientiousness"))
summary(out)

## Analysis of the validity of the Big Five traits as predictors of job performance in East Asia
out <- ma_r_order2(k = k, r = r_bar_i, rho = rho_bar_i, var_r = var_r,
                   var_r_c = NULL, ma_type = c("bb", "ad"),
                   sample_id = NULL, moderators = NULL, construct_x = Predictor,
                   data = data_r_oh_2009)
summary(out)

## Analysis of the average validity of the Big Five traits as predictors of
## job performance by Eastern Asian country
out <- ma_r_order2(k = k, r = r_bar_i, rho = rho_bar_i, var_r = var_r,
                   var_r_c = NULL, ma_type = c("bb", "ad"),
                   sample_id = NULL, moderators = "Country", data = data_r_oh_2009)
summary(out)
}
