% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_ma.R
\name{.convert_metatab}
\alias{.convert_metatab}
\title{Function to convert a meta-analysis of correlations to a meta-analysis of d values or vice-versa (does one table)}
\usage{
.convert_metatab(ma_table, p_vec = rep(0.5, nrow(ma_table)),
  conf_level = 0.95, cred_level = 0.8, conf_method = "t",
  cred_method = "t")
}
\arguments{
\item{ma_table}{Meta-analysis table.}

\item{p_vec}{Vector of proportions associated with the rows of \code{ma_table}.}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{cred_level}{Credibility level to define the width of the credibility interval (default = .80).}

\item{conf_method}{Distribution to be used to compute the width of confidence intervals. Available options are "t" for t distribution or "norm" for normal distribution.}

\item{cred_method}{Distribution to be used to compute the width of credibility intervals. Available options are "t" for t distribution or "norm" for normal distribution.}
}
\value{
Meta-analysis table converted to a new metric
}
\description{
Function to convert a meta-analysis of correlations to a meta-analysis of d values or vice-versa (does one table)
}
\keyword{internal}
