% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_r_ic.R
\name{.refine_var_rr}
\alias{.refine_var_rr}
\title{Range-restriction refinement factor (i.e., "a") for correlations' corrected sampling variances}
\usage{
.refine_var_rr(rxyi, ux, rxx = NULL, indirect_rr = rep(TRUE,
  length(rxyi)), ux_observed = rep(TRUE, length(rxyi)),
  rxx_restricted = rep(TRUE, length(rxyi)))
}
\arguments{
\item{rxyi}{Vector of observed correlations.}

\item{ux}{Vector of u ratios.}

\item{rxx}{Vector of reliability estimates.}

\item{indirect_rr}{Logical vector determining whether a correction for indirect range restriction was performed (TRUE) or not (FALSE).}

\item{ux_observed}{Logical vector determining whether each element of ux is an observed-score u ratio (TRUE) or a true-score u ratio (FALSE).}

\item{rxx_restricted}{Logical vector determining whether each element of rxx is an incumbent reliability (TRUE) or an applicant reliability (FALSE).}
}
\value{
A vector of range-restriction refinement factors.
}
\description{
For use with Case II and Case IV range restriction (not for use with Case V).
}
\examples{
\dontrun{
.refine_var_rr(rxyi = .3, ux = .8, rxx = .8, indirect_rr = TRUE,
         ux_observed = TRUE, rxx_restricted = TRUE)
}
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings (3rd ed.)}.
Thousand Oaks, California: SAGE Publications, Inc. p. 145.
}
\keyword{internal}
