% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_d.R
\name{correct_d}
\alias{correct_d}
\title{Correct \emph{d} values for range restriction and/or measurement error}
\usage{
correct_d(correction = c("meas", "uvdrr_g", "uvdrr_y", "uvirr_g", "uvirr_y",
  "bvdrr", "bvirr"), d, ryy = 1, uy = 1, rGg = 1, pi = NULL,
  pa = NULL, uy_observed = TRUE, ryy_restricted = TRUE,
  ryy_type = "alpha", sign_rgz = 1, sign_ryz = 1, n1 = NULL, n2 = NA,
  conf_level = 0.95, correct_bias = FALSE)
}
\arguments{
\item{correction}{Type of correction to be applied. Options are "meas", "uvdrr_g", "uvdrr_y", "uvirr_g", "uvirr_y", "bvdrr", "bvirr"}

\item{d}{Vector of \emph{d} values.}

\item{ryy}{Vector of reliability coefficients for Y (the continuous variable).}

\item{uy}{Vector of u ratios for Y (the continuous variable).}

\item{rGg}{Vector of reliabilities for the group variable (i.e., the correlations between observed group membership and latent group membership).}

\item{pi}{Proportion of cases in one of the groups in the observed data (not necessary if \code{n1} and \code{n2} reflect this proportionality).}

\item{pa}{Proportion of cases in one of the groups in the population.}

\item{uy_observed}{Logical vector in which each entry specifies whether the corresponding uy value is an observed-score u ratio (\code{TRUE}) or a true-score u ratio. All entries are \code{TRUE} by default.}

\item{ryy_restricted}{Logical vector in which each entry specifies whether the corresponding rxx value is an incumbent reliability (\code{TRUE}) or an applicant reliability. All entries are \code{TRUE} by default.}

\item{ryy_type}{String vector identifying the types of reliability estimates supplied (e.g., "alpha", "retest", "interrater_r", "splithalf"). See the documentation for \code{\link{ma_r}} for a full list of acceptable reliability types.}

\item{sign_rgz}{Vector of signs of the relationships between grouping variables and the selection mechanism.}

\item{sign_ryz}{Vector of signs of the relationships between Y variables and the selection mechanism.}

\item{n1}{Optional vector of sample sizes associated with group 1 (or the total sample size, if \code{n2} is \code{NULL}).}

\item{n2}{Optional vector of sample sizes associated with group 2.}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{correct_bias}{Logical argument that determines whether to correct error-variance estimates for small-sample bias in correlations (\code{TRUE}) or not (\code{FALSE}).
For sporadic corrections (e.g., in mixed artifact-distribution meta-analyses), this should be set to \code{FALSE} (the default).}
}
\value{
Data frame(s) of observed \emph{d} values (\code{dgyi}), operational range-restricted \emph{d} values corrected for measurement error in Y only (\code{dgpi}), operational range-restricted \emph{d} values corrected for measurement error in the grouping only (\code{dGyi}), and range-restricted true-score \emph{d} values (\code{dGpi}),
range-corrected observed-score \emph{d} values (\code{dgya}), operational range-corrected \emph{d} values corrected for measurement error in Y only (\code{dgpa}), operational range-corrected \emph{d} values corrected for measurement error in the grouping only (\code{dGya}), and range-corrected true-score \emph{d} values (\code{dGpa}).
}
\description{
This function is a wrapper for the \code{\link{correct_r}} function to correct \emph{d} values for statistical and psychometric artifacts.
}
\examples{
## Correction for measurement error only
correct_d(correction = "meas", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = .7, pa = .5)
correct_d(correction = "meas", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = NULL, pa = .5, n1 = 100, n2 = 200)

## Correction for direct range restriction in the continuous variable
correct_d(correction = "uvdrr_y", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = .7, pa = .5)
correct_d(correction = "uvdrr_y", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = NULL, pa = .5, n1 = 100, n2 = 200)

## Correction for direct range restriction in the grouping variable
correct_d(correction = "uvdrr_g", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = .7, pa = .5)
correct_d(correction = "uvdrr_g", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = NULL, pa = .5, n1 = 100, n2 = 200)

## Correction for indirect range restriction in the continuous variable
correct_d(correction = "uvdrr_y", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = .7, pa = .5)
correct_d(correction = "uvdrr_y", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = NULL, pa = .5, n1 = 100, n2 = 200)

## Correction for indirect range restriction in the grouping variable
correct_d(correction = "uvirr_g", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = .7, pa = .5)
correct_d(correction = "uvirr_g", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = NULL, pa = .5, n1 = 100, n2 = 200)

## Correction for indirect range restriction in the continuous variable
correct_d(correction = "uvdrr_y", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = .7, pa = .5)
correct_d(correction = "uvdrr_y", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = NULL, pa = .5, n1 = 100, n2 = 200)

## Correction for direct range restriction in both variables
correct_d(correction = "bvdrr", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = .7, pa = .5)
correct_d(correction = "bvdrr", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = NULL, pa = .5, n1 = 100, n2 = 200)

## Correction for indirect range restriction in both variables
correct_d(correction = "bvirr", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = .7, pa = .5)
correct_d(correction = "bvirr", d = .5, ryy = .8, uy = .7,
          rGg = .9, pi = NULL, pa = .5, n1 = 100, n2 = 200)
}
\references{
Alexander, R. A., Carson, K. P., Alliger, G. M., & Carr, L. (1987).
Correcting doubly truncated correlations: An improved approximation for correcting the bivariate normal correlation when truncation has occurred on both variables.
\emph{Educational and Psychological Measurement, 47}(2), 309–315. \url{https://doi.org/10.1177/0013164487472002}

Dahlke, J. A., & Wiernik, B. M. (2018). \emph{One of these artifacts is not like the others:
Accounting for indirect range restriction in organizational and psychological research}.
Manuscript submitted for review.

Hunter, J. E., Schmidt, F. L., & Le, H. (2006).
Implications of direct and indirect range restriction for meta-analysis methods and findings.
\emph{Journal of Applied Psychology, 91}(3), 594–612. \url{https://doi.org/10.1037/0021-9010.91.3.594}

Le, H., Oh, I.-S., Schmidt, F. L., & Wooldridge, C. D. (2016).
Correction for range restriction in meta-analysis revisited: Improvements and implications for organizational research.
\emph{Personnel Psychology, 69}(4), 975–1008. \url{https://doi.org/10.1111/peps.12122}

Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: SAGE. \url{https://doi.org/10/b6mg}. pp. 43–44, 140–141.
}
