% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_ad_wrappers.R
\name{create_ad_list}
\alias{create_ad_list}
\title{Create a list of artifact distributions by construct}
\usage{
create_ad_list(ad_type = "tsa", n, sample_id = NULL, construct_x,
  measure_x = NULL, construct_y, measure_y = NULL, rxx = NULL,
  rxx_restricted = TRUE, rxx_type = "alpha", ryy = NULL,
  ryy_restricted = TRUE, ryy_type = "alpha", ux = NULL,
  ux_observed = TRUE, uy = NULL, uy_observed = TRUE,
  estimate_rxxa = TRUE, estimate_rxxi = TRUE, estimate_ux = TRUE,
  estimate_ut = TRUE, var_unbiased = TRUE, process_ads = TRUE,
  collapse_method = c("composite", "average", "stop"), intercor = 0.5,
  supplemental_ads = NULL, data = NULL, ...)
}
\arguments{
\item{ad_type}{Type of artifact distributions to be computed: Either "tsa" for Taylor series approximation or "int" for interactive.}

\item{n}{Vector or column name of sample sizes.}

\item{sample_id}{Optional vector of identification labels for samples/studies in the meta-analysis.}

\item{construct_x}{Vector of construct names for construct initially designated as X.}

\item{measure_x}{Vector of names for measures associated with constructs initially designated as "X".}

\item{construct_y}{Vector of construct names for construct initially designated as Y.}

\item{measure_y}{Vector of names for measures associated with constructs initially designated as "Y".}

\item{rxx}{Vector or column name of reliability estimates for X.}

\item{rxx_restricted}{Logical vector or column name determining whether each element of rxx is an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{rxx_type, ryy_type}{String vector identifying the types of reliability estimates supplied. Acceptable reliability types are:}

\item{ryy}{Vector or column name of reliability estimates for Y.}

\item{ryy_restricted}{Logical vector or column name determining whether each element of ryy is an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{ux}{Vector or column name of u ratios for X.}

\item{ux_observed}{Logical vector or column name determining whether each element of ux is an observed-score u ratio (\code{TRUE}) or a true-score u ratio (\code{FALSE}).}

\item{uy}{Vector or column name of u ratios for Y.}

\item{uy_observed}{Logical vector or column name determining whether each element of uy is an observed-score u ratio (\code{TRUE}) or a true-score u ratio (\code{FALSE}).}

\item{estimate_rxxa}{Logical argument to estimate rxxa values from other artifacts (\code{TRUE}) or to only used supplied rxxa values (\code{FALSE}). \code{TRUE} by default.}

\item{estimate_rxxi}{Logical argument to estimate rxxi values from other artifacts (\code{TRUE}) or to only used supplied rxxi values (\code{FALSE}). \code{TRUE} by default.}

\item{estimate_ux}{Logical argument to estimate ux values from other artifacts (\code{TRUE}) or to only used supplied ux values (\code{FALSE}). \code{TRUE} by default.}

\item{estimate_ut}{Logical argument to estimate ut values from other artifacts (\code{TRUE}) or to only used supplied ut values (\code{FALSE}). \code{TRUE} by default.}

\item{var_unbiased}{Logical scalar determining whether variances should be unbiased (\code{TRUE}) or maximum-likelihood (\code{FALSE}).}

\item{process_ads}{Logical scalar determining whether artifact information should be processed into "ad_obj" class objects (\code{TRUE}; default) or reported in list form (\code{FALSE}).}

\item{collapse_method}{Character argument that determines how to collapse multiple measures of a construct within a single study (used when \code{measure_x} and/or \code{measure_y} are supplied).
Options are "composite" (default), "average," and "stop." When measure names are not supplied, multiple entries for a given construct within a given study will be averaged.}

\item{intercor}{The intercorrelation(s) among variables to be combined into a composite. Can be a scalar or a named vector with element named according to the names of constructs. Default value is .5.}

\item{supplemental_ads}{Named list (named according to the constructs included in the meta-analysis) of supplemental artifact distribution information from studies not included in the meta-analysis. This is a list of lists, where the elements of a list associated with a construct are named like the arguments of the \code{create_ad()} function.}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments.}

\item{...}{Additional arguments}
}
\value{
A list of artifact distributions
}
\description{
Create a list of artifact distributions by construct
}
\examples{
create_ad_list(n = n, rxx = rxxi, ryy = ryyi,
               construct_x = x_name, construct_y = y_name,
               sample_id = sample_id,
               data = data_r_meas_multi)
}
