% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printAovMeans.R
\name{printAovMeans}
\alias{printAovMeans}
\title{printAovMeans}
\usage{
printAovMeans(ezObj, caption = "Mean", digits = 3, dv = "ms")
}
\arguments{
\item{ezObj}{Output from ezANOVA  (NB. ezANOVA must be called with \"return_aov = TRUE\"")}

\item{caption}{Title for the table}

\item{digits}{Number of digits to round to}

\item{dv}{Name of the dependent variable (e.g., "ms", "\%")}
}
\value{
character
}
\description{
Returns Latex formatted table of marginal means from model.tables.
Uses printTable (xtable) latex package with some basic defaults.
For more examples, see R package xtable
}
\examples{
library(psychReport)
requiredPackages(c("ez"))
# Example 1:
# create dataframe
dat <- createDF(nVP = 6,
                nTrl = 1,
                design = list("Comp" = c("comp", "incomp")))

dat <- addDataDF(dat, RT = list(list(c("Comp:comp"), vals = c(500, 150, 100)),
                                list(c("Comp:incomp"), vals =c(520, 150, 100))))

aovRT <- ezANOVA(dat, dv=.(RT), wid = .(VP), within = .(Comp), return_aov = TRUE, detailed = TRUE)
aovRT <- aovTable(aovRT)
printAovMeans(aovRT)  # latex formatted

\dontrun{
# Example use in *.Rnw Sweave file inside R chunk
# << printTable, echo = FALSE, results = tex >>=
# printAovMeans(aovRT, caption = "ANOVA Table")
# @}

}
