% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_survkm.R
\name{psrwe_survkm}
\alias{psrwe_survkm}
\title{PS-Integrated Kaplan-Meier Estimation}
\usage{
psrwe_survkm(dta_psbor, v_time = "time", v_event = "event", pred_tp = 1, ...)
}
\arguments{
\item{dta_psbor}{A class \code{PSRWE_BOR} object generated by
\code{\link{psrwe_borrow}}.}

\item{v_time}{Column name corresponding to event time}

\item{v_event}{Column name corresponding to event status}

\item{pred_tp}{Time of interest (e.g., 1 year)}

\item{...}{Additional Parameters.}
}
\value{
A data frame with class name \code{PSRWE_RST}. It contains the
    composite estimation of the mean for each stratum as well as the
    jackknife estimation. The results should be further
    summarized by its S3 method \code{summary}.
}
\description{
Estimate the mean of a survival outcome at a given time point based on
PS-integrated Kaplan-Meier approach. Variance is estimated by Jack-Knife
method. Applies to the case when there is only one external data source.
}
\examples{
data(ex_dta)
dta_ps <- psrwe_est(ex_dta,
       v_covs = paste("V", 1:7, sep = ""),
       v_grp = "Group",
       cur_grp_level = "current")
ps_borrow <- psrwe_borrow(total_borrow = 30, dta_ps)
rst       <- psrwe_survkm(ps_borrow,
                           v_time = "Y_Surv",
                           v_event = "Status")
rst

}
