% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psfmi_lr.R
\name{psfmi_lr}
\alias{psfmi_lr}
\title{Pooling and Predictor selection function for Logistic regression
models in multiply imputed datasets}
\usage{
psfmi_lr(
  data,
  nimp = 5,
  impvar = NULL,
  Outcome,
  predictors = NULL,
  p.crit = 1,
  cat.predictors = NULL,
  spline.predictors = NULL,
  int.predictors = NULL,
  keep.predictors = NULL,
  knots = NULL,
  method = "RR",
  print.method = FALSE
)
}
\arguments{
\item{data}{Data frame with stacked multiple imputed datasets.
The original dataset that contains missing values must be excluded from the
dataset. The imputed datasets must be distinguished by an imputation variable,
specified under impvar, and starting by 1.}

\item{nimp}{A numerical scalar. Number of imputed datasets. Default is 5.}

\item{impvar}{A character vector. Name of the variable that distinguishes the
imputed datasets.}

\item{Outcome}{Character vector containing the name of the outcome variable.}

\item{predictors}{Character vector with the names of the predictor variables.
At least one predictor variable has to be defined.}

\item{p.crit}{A numerical scalar. P-value selection criterium. A value of 1 
provides the pooled model without selection.}

\item{cat.predictors}{A single string or a vector of strings to define the
categorical variables. Default is NULL categorical predictors.}

\item{spline.predictors}{A single string or a vector of strings to define the
(restricted cubic) spline variables. Default is NULL spline predictors. See details.}

\item{int.predictors}{A single string or a vector of strings with the names of the variables that form
an interaction pair, separated by a “:” symbol.}

\item{keep.predictors}{A single string or a vector of strings including the variables that are forced
in the model during predictor selection. Categorical and interaction variables are allowed.}

\item{knots}{A numerical vector that defines the number of knots for each spline predictor separately.}

\item{method}{A character vector to indicate the pooling method for p-values to pool the
total model or used during predictor selection. This can be "D1", "D2", "D3" or "MPR".
See details for more information.}

\item{print.method}{logical vector. If TRUE full matrix with p-values of all variables according to
chosen method (under method) is shown. If FALSE (default) p-value for categorical variables according
to method are shown and for continuous and dichotomous predictors Rubin’s Rules are used.}
}
\value{
An object of class \code{smodsmi} (selected models in multiply imputed datasets) from 
 which the following objects can be extracted: imputed datasets as \code{data}, selected 
 pooled model as \code{RR_model}, pooled p-values according to pooling method as \code{multiparm}, 
 predictors included at each selection step as \code{predictors_in}, predictors excluded at each step 
 as \code{predictors_out}, and \code{impvar}, \code{nimp}, \code{Outcome}, \code{method}, \code{p.crit}, 
 \code{predictors}, \code{cat.predictors}, \code{keep.predictors}, \code{int.predictors}, 
 \code{spline.predictors}, \code{knots}, \code{print.method}, \code{call}, \code{model_type},
 \code{predictors_final} for names of predictors in final selection step, \code{fit.formula} is the 
 regression formula of start model and \code{predictors_initial} for names of predictors in start
 model.
}
\description{
\code{psfmi_lr} Pooling and backward selection for Logistic regression
prediction models in multiply imputed datasets using different selection methods.
}
\details{
The basic pooling procedure to derive pooled coefficients, standard errors, 95
 confidence intervals and p-values is Rubin's Rules (RR). Specific procedures are
 available to derive pooled p-values for categorical (> 2 categories) and spline variables.
 print.method allows to choose between the pooling methods: “D1” is pooling of the total 
 covariance matrix, ”D2” is pooling of Chi-square values, “D3” is pooling Likelihood ratio 
 statistics (method of Meng and Rubin) and “MPR” is pooling of median p-values (MPR rule). 
 Spline regression coefficients are defined by using the rcs function for restricted cubic 
 splines of the rms package. A minimum number of 3 knots as defined under knots is required.
}
\examples{
  pool_lr <- psfmi_lr(data=lbpmilr, nimp=5, impvar="Impnr", Outcome="Chronic",
  predictors=c("Gender", "Smoking", "Function", "JobControl",
  "JobDemands", "SocialSupport"), method="D1")
  pool_lr$RR_Model
  pool_lr$multiparm

  pool_lr <- psfmi_lr(data=lbpmilr, nimp=5, impvar="Impnr", Outcome="Chronic",
  predictors=c("Gender", "Smoking", "Function", "JobControl",
  "JobDemands", "SocialSupport"), p.crit = 0.05, method="D1")
  pool_lr$RR_Model
  pool_lr$multiparm
  pool_lr$predictors_in

}
\references{
Eekhout I, van de Wiel MA, Heymans MW. Methods for significance testing of categorical
  covariates in logistic regression models after multiple imputation: power and applicability
  analysis. BMC Med Res Methodol. 2017;17(1):129.

Enders CK (2010). Applied missing data analysis. New York: The Guilford Press.

Meng X-L, Rubin DB. Performing likelihood ratio tests with multiply-imputed data sets.
  Biometrika.1992;79:103-11.

van de Wiel MA, Berkhof J, van Wieringen WN. Testing the prediction error difference between
  2 predictors. Biostatistics. 2009;10:550-60.

Marshall A, Altman DG, Holder RL, Royston P. Combining estimates of interest in prognostic
  modelling studies after multiple imputation: current practice and guidelines. BMC Med Res Methodol.
  2009;9:57.

Van Buuren S. (2018). Flexible Imputation of Missing Data. 2nd Edition. Chapman & Hall/CRC
  Interdisciplinary Statistics. Boca Raton.

EW. Steyerberg (2019). Clinical Prediction MOdels. A Practical Approach 
 to Development, Validation, and Updating (2nd edition). Springer Nature Switzerland AG.

http://missingdatasolutions.rbind.io/
}
