% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrate.R
\name{sp_locscale}
\alias{sp_locscale}
\title{Fit the semi-parametric location-scale model}
\usage{
sp_locscale(formula.location, formula.scale, data, weights, tol = 1e-06,
  maxit = 100)
}
\arguments{
\item{formula.location}{Formula specifying the model for the location}

\item{formula.scale}{Formula specifying the model for the scale}

\item{data}{Data used to estimate the model}

\item{weights}{Weights applied to the estimating equations}

\item{tol}{Convergence tolerance}

\item{maxit}{Maximum number of iterations}
}
\value{
A list containing the parameter estimates, the convergence indicator, and residuals
}
\description{
This estimates the location-scale model as described in Heagerty and Pepe (1999) using the Newton-Raphson method. The location and scale formulas must have the same outcome, but they may have different predictors.
}
