% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/func_pspectrum.R
\name{pspectrum}
\alias{adapt_message}
\alias{pspectrum}
\alias{pspectrum.default}
\alias{pspectrum.spec}
\alias{pspectrum.ts}
\alias{pspectrum_basic}
\title{Adaptive sine multitaper power spectral density estimation}
\usage{
pspectrum(x, ...)

\method{pspectrum}{ts}(x, ...)

\method{pspectrum}{spec}(x, ...)

\method{pspectrum}{default}(x, x.frqsamp = 1, ntap.init = NULL, niter = 5,
  AR = FALSE, Nyquist.normalize = TRUE, verbose = TRUE,
  no.history = FALSE, plot = FALSE, ...)

pspectrum_basic(x, ntap.init = 7, niter = 5, verbose = TRUE, ...)

adapt_message(stage, dvar = NULL)
}
\arguments{
\item{x}{vector; series to find PSD estimates for}

\item{...}{Optional parameters passed to \code{\link{riedsid}}}

\item{x.frqsamp}{scalar; the sampling rate (e.g. Hz) of the series \code{x}; equivalent to \code{\link{frequency}}.}

\item{ntap.init}{scalar; the number of sine tapers to use in the pilot spectrum estimation; if \code{NULL} then the
default in \code{\link{pilot_spec}} is used.}

\item{niter}{scalar; the number of adaptive iterations to execute after the pilot spectrum is estimated.}

\item{AR}{logical; should the effects of an AR model be removed from the pilot spectrum?}

\item{Nyquist.normalize}{logical; should the units be returned on Hz, rather than Nyquist?}

\item{verbose}{logical; Should messages be given?}

\item{no.history}{logical; Should the adaptive history \emph{not} be saved?}

\item{plot}{logical; Should the results be plotted?}

\item{stage}{integer; the current adaptive stage (0 is pilot)}

\item{dvar}{numeric; the spectral variance; see also \code{\link{vardiff}} etc}
}
\value{
Object with class 'spec', invisibly. It also assigns the object to
\code{"final_psd"} in the working environment.
}
\description{
This is the primary function to be used in this package: it returns
power spectral density estimates of a univariate timeseries, with
an optimal number of tapers at each frequency based on iterative
reweighted spectral derivatives.
}
\details{
See the \strong{Adaptive estimation} section in the description of
the \code{\link{psd-package}} for details regarding adaptive estimation.

\code{\link{pspectrum_basic}} is a simplified implementation used mainly for
testing.
}
\examples{
\dontrun{#REX
library(psd)
library(RColorBrewer)

##
## Adaptive multitaper PSD estimation
## (see also the  "psd_overview"  vignette)
##

data(magnet)
Xr <- magnet$raw
Xc <- magnet$clean

# adaptive psd estimation (turn off diagnostic plot)
PSDr <- pspectrum(Xr, plot=FALSE)
PSDc <- pspectrum(Xc, plot=FALSE)

# plot them on the same scale
plot(PSDc, log="dB",
     main="Raw and cleaned Project MAGNET power spectral density estimates",
     lwd=3, ci.col=NA, ylim=c(0,32), yaxs="i")
plot(PSDr, log="dB", add=TRUE, lwd=3, lty=5)
text(c(0.25,0.34), c(11,24), c("Clean","Raw"), cex=1)

## Change sampling, and inspect the diagnostic plot
plot(pspectrum(Xc, niter=1, x.frqsamp=10, plot=TRUE))

## Say we forgot to assign the results: we can recover from the environment with:
PSDc_recovered <- psd_envGet("final_psd")
plot(PSDc_recovered)

}#REX
}
\author{
A.J. Barbour adapted original by R.L. Parker
}
\seealso{
\code{\link{psdcore}}, \code{\link{pilot_spec}}, \code{\link{riedsid}}, \code{\link{prewhiten}}
}

