% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_surv_weibull_ph.R
\name{outcome_surv_weibull_ph}
\alias{outcome_surv_weibull_ph}
\title{Weibull survival distribution (proportional hazards formulation)}
\usage{
outcome_surv_weibull_ph(
  time_var,
  cens_var,
  shape_prior,
  baseline_prior,
  weight_var = ""
)
}
\arguments{
\item{time_var}{character. Name of time variable column in model matrix}

\item{cens_var}{character. Name of the censorship variable flag in model matrix}

\item{shape_prior}{\code{Prior} class object for the Weibull shape
parameter. Default is \code{prior_exponential(beta = 0.0001)}.}

\item{baseline_prior}{\code{Prior}. Object of class \code{Prior}
specifying prior distribution for the baseline outcome.
See \code{Details} for more information.}

\item{weight_var}{character. Optional name of variable in model matrix for weighting the log likelihood.}
}
\value{
Object of class \code{\link[=OutcomeSurvWeibullPH-class]{OutcomeSurvWeibullPH}}.
}
\description{
Weibull survival distribution (proportional hazards formulation)
}
\details{
\subsection{Baseline Prior}{

The \code{baseline_prior} argument specifies the prior distribution for the
baseline log hazard rate. The interpretation of the \code{baseline_prior} differs
slightly between borrowing methods selected.
\itemize{
\item \emph{Dynamic borrowing using \code{borrowing_hierarchical_commensurate()}}: the \code{baseline_prior} for Bayesian Dynamic Borrowing
refers to the log hazard rate of the external control arm.
\item \emph{Full borrowing} or \emph{No borrowing} using \code{borrowing_full()} or \code{borrowing_none()}: the \code{baseline_prior} for
these borrowing methods refers to the log hazard rate for the
internal control arm.
}
}
}
\examples{
ws <- outcome_surv_weibull_ph(
  time_var = "time",
  cens_var = "cens",
  shape_prior = prior_exponential(1),
  baseline_prior = prior_normal(0, 1000)
)
}
\seealso{
Other outcome models: 
\code{\link{outcome_bin_logistic}()},
\code{\link{outcome_cont_normal}()},
\code{\link{outcome_surv_exponential}()}
}
\concept{outcome models}
