% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_shared_libs}
\alias{ps_shared_libs}
\title{List the dynamically loaded libraries of a process}
\usage{
ps_shared_libs(p = ps_handle())
}
\arguments{
\item{p}{Process handle.}
}
\value{
Data frame with one column currently: \code{path}, the
absolute path to the loaded module or shared library. On Windows
the list includes the executable file itself.
}
\description{
Note: this function currently only works on Windows.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check() && ps::ps_os_type()[["WINDOWS"]]) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# The loaded DLLs of the current process
ps_shared_libs()
\dontshow{\}) # examplesIf}
}
\seealso{
Other process handle functions: 
\code{\link{ps_children}()},
\code{\link{ps_cmdline}()},
\code{\link{ps_connections}()},
\code{\link{ps_cpu_times}()},
\code{\link{ps_create_time}()},
\code{\link{ps_cwd}()},
\code{\link{ps_descent}()},
\code{\link{ps_environ}()},
\code{\link{ps_exe}()},
\code{\link{ps_handle}()},
\code{\link{ps_interrupt}()},
\code{\link{ps_is_running}()},
\code{\link{ps_kill}()},
\code{\link{ps_memory_info}()},
\code{\link{ps_name}()},
\code{\link{ps_num_fds}()},
\code{\link{ps_num_threads}()},
\code{\link{ps_open_files}()},
\code{\link{ps_pid}()},
\code{\link{ps_ppid}()},
\code{\link{ps_resume}()},
\code{\link{ps_send_signal}()},
\code{\link{ps_status}()},
\code{\link{ps_suspend}()},
\code{\link{ps_terminal}()},
\code{\link{ps_terminate}()},
\code{\link{ps_uids}()},
\code{\link{ps_username}()}

Other shared library tools: 
\code{\link{ps_shared_lib_users}()}
}
\concept{process handle functions}
\concept{shared library tools}
