% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{densities}
\alias{densities}
\title{A list of rock and mineral densities}
\description{
List of rock and mineral densities using the following
abbreviations: Q (quartz), KF (K-feldspar), P (plagioclase), F
(feldspar), Lvf (felsic/porfiritic volcanic rock fragments), Lvm
(microlithic / porfiritic / trachitic volcanic rock fragments), Lcc
(calcite), Lcd (dolomite), Lp (marl), Lch (chert), Lms
(argillaceous / micaceous rock fragments), Lmv (metavolcanics), Lmf
(metasediments), Lmb (metabasites), Lv (volcanic rock fragments),
Lc (carbonates), Ls (sedimentary rock fragments), Lm (metamorphic
rock fragments), Lu (serpentinite), mica, opaques, FeOx
(Fe-oxides), turbids, zr (zircon), tm (tourmaline), rt (rutile),
TiOx (Ti-oxides), sph (titanite), ap (apatite), mon (monazite), oth
(other minerals), ep (epidote), othLgM (prehnite + pumpellyite +
lawsonite + carpholite), gt (garnet), ctd (chloritoid), st
(staurolite), and (andalusite), ky (kyanite), sil (sillimanite),
amp (amphibole), px (pyroxene), cpx (clinopyroxene), opx
(orthopyroxene), ol (olivine), spinel and othHM (other heavy
minerals).
}
\examples{
data(Namib,densities)
N8 <- subset(Namib$HM,select="N8")
distribution <- minsorting(N8,densities,phi=2,sigmaphi=1,medium="air",by=0.05)
plot(distribution)
}
\references{
Resentini, A, Malusa M G and Garzanti, E. "MinSORTING:
An Excel worksheet for modelling mineral grain-size distribution in
sediments, with application to detrital geochronology and
provenance studies." Computers & Geosciences 59 (2013): 90-97.

Garzanti, E, Ando, S and Vezzoli, G. "Settling
equivalence of detrital minerals and grain-size dependence of
sediment composition." Earth and Planetary Science Letters 273.1
(2008): 138-151.
}
\seealso{
restore, minsorting
}
\author{
Alberto Resentini and Pieter Vermeesch
}
