% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\docType{data}
\name{Namib}
\alias{Namib}
\title{An example dataset}
\description{
A large dataset of provenance data from Namibia comprised of 14
sand samples from the Namib Sand Sea and 2 samples from the Orange
River.
}
\details{
\code{Namib} is a list containing the following 6 items:

\code{DZ}: a \code{distributional} dataset containing the zircon
U-Pb ages for ca. 100 grains from each sample, as well as their
(1-sigma) analytical uncertainties.

\code{PT}: a \code{compositional} dataset with the bulk petrography
of the samples, i.e. the quartz ('Q'), K-feldspar ('KF'),
plagioclase ('P'), and lithic fragments of metamorphic ('Lm'),
volcanic ('Lv') and sedimentary ('Ls') origin.

\code{HM}: a \code{compositional} dataset containing the heavy
mineral composition of the samples, comprised of zircon ('zr'),
tourmaline ('tm'), rutile ('rt'), Ti-oxides ('TiOx'), titanite
('sph'), apatite ('ap'), epidote ('ep'), garnet ('gt'), staurolite
('st'), andalusite ('and'), kyanite ('ky'), sillimanite ('sil'),
amphibole ('amp'), clinopyroxene ('cpx') and orthopyroxene ('opx').

\code{PTHM}: a \code{compositional} dataset combining the variables
contained in \code{PT} and \code{HM} plus 'mica', 'opaques',
'turbids' and 'other' transparent heavy minerals ('LgM'),
normalised to 100.

\code{Major}: a \code{compositional} dataset listing the
concentrations (in wt%) of SiO2, Al2O3, Fe2O3, MgO, CaO, Na2O, K2O,
TiO2, P2O5 and MnO.

\code{Trace}: a \code{compositional} data listing the concentrations
(in ppm) of Rb, Sr, Ba, Sc, Y, La, Ce, Pr, Nd, Sm, Gd, Dy, Er, Yb, Th,
U, Zr, Hf, V, Nb, Cr, Co, Ni, Cu, Zn, Ga and Pb.
}
\examples{
data(Namib)
samp <- Namib$DZ$x[['N1']]
dens <- KDE(samp,0,3000)
plot(dens)
}
\references{
Vermeesch, P. and Garzanti, E., Making geological sense
of 'Big Data' in sedimentary provenance analysis, Chemical Geology
409 (2015) 20-27
}
\author{
Pieter Vermeesch and Eduardo Garzanti
}
