% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde.R
\name{KDEs}
\alias{KDEs}
\title{Generate an object of class \code{KDEs}}
\usage{
KDEs(x, from = NA, to = NA, bw = NA, samebandwidth = TRUE,
  adaptive = TRUE, pch = NA, normalise = FALSE, log = FALSE, n = 512,
  ...)
}
\arguments{
\item{x}{an object of class \code{distributional}}

\item{from}{minimum limit of the x-axis.}

\item{to}{maximum limit of the x-axis.}

\item{bw}{the bandwidth of the kernel density estimates. If bw =
NA, the bandwidth will be set automatically using \code{botev()}}

\item{samebandwidth}{boolean flag indicating whether the same
bandwidth should be used for all samples. If samebandwidth = TRUE
and bw = NULL, then the function will use the median bandwidth of
all the samples.}

\item{adaptive}{boolean flag switching on the adaptive bandwidth
modifier of Abramson (1982)}

\item{pch}{(optional) symbol to be used to mark the sample points along the x-axis}

\item{normalise}{boolean flag indicating whether or not the KDEs
should all integrate to the same value.}

\item{log}{boolean flag indicating whether the data should by
plotted on a logarithmic scale.}

\item{n}{horizontal resolution of the density estimates}

\item{...}{optional parameters to be passed on to \code{density}}
}
\value{
an object of class \code{KDEs}, i.e. a list containing the
following items:

kdes: a named list with objects of class \code{KDE}

from: the beginning of the common time scale

to: the end of the common time scale

themax: the maximum probability density of all the KDEs

pch: the plot symbol to be used by \code{plot.KDEs}

xlabel: the x-axis label to be used by \code{plot.KDEs}
}
\description{
Convert a dataset of class \code{distributional} into an object of
class \code{KDEs} for further processing by the
\code{summaryplot} function.
}
\examples{
data(Namib)
KDEs <- KDEs(Namib$DZ,0,3000,pch=NA)
summaryplot(KDEs,ncol=3)
}
\seealso{
KDE
}

