% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{diss}
\alias{diss}
\alias{diss.compositional}
\alias{diss.distributional}
\title{Calculate the dissimilarity matrix between two \code{distributional} or
\code{compositional} datasets}
\usage{
diss(x, method)

\method{diss}{distributional}(x, method = NULL)

\method{diss}{compositional}(x, method = NULL)
}
\arguments{
\item{x}{an object of class \code{distributional} or \code{compositional}}

\item{method}{(optional) either "KS", "SH", "aitchison" or "bray"}
}
\value{
an object of class \code{diss}
}
\description{
Calculate the dissimilarity matrix between two datasets of class
\code{distributional} or \code{compositional} using the Kolmogorov-Smirnov,
Sircombe-Hazelton, Aitchison or Bray Curtis distance
}
\examples{
data(Namib)
print(round(100*diss(Namib$DZ)))
}

