% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{clr}
\alias{clr}
\alias{clr.compositional}
\title{Centred logratio transformation}
\usage{
clr(x, ...)

\method{clr}{compositional}(x, ...)
}
\arguments{
\item{x}{an object of class \code{compositional}}

\item{...}{optional arguments of the generic function}
}
\value{
a matrix of clr coordinates
}
\description{
Calculates Aitchison's centered logratio transformation for a
dataset of class \code{compositional}
}
\examples{
# The following code shows that applying provenance's PCA function
# to compositional data is equivalent to applying R's built-in
# princomp function to the clr transformed data.
data(Namib)
plot(PCA(Namib$Major))
dev.new()
clrdat <- clr(Namib$Major)$x
biplot(princomp(clrdat))
}

