% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{plot.KDE}
\alias{plot.KDE}
\title{Plot a kernel density estimate}
\usage{
\method{plot}{KDE}(x, pch = "|", xlab = "age [Ma]", ylab = "", ...)
}
\arguments{
\item{x}{an object of class \code{KDE}}

\item{pch}{the symbol used to show the samples. Set \code{pch = NA}
to turn them off}

\item{xlab}{the label of the x-axis}

\item{ylab}{the label of the y-axis}

\item{...}{optional parameters to be passed on to the graphics object}
}
\description{
Plots an object of class \code{KDE}
}
\examples{
fname <- system.file("DZ.csv",package="provenance")
DZ <- read.DZdata(fname)
samp <- DZ$x[['N1']]
dens <- getKDE(samp,0,3000)
plot(dens)
}

