% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woods_plot.R
\name{woods_plot}
\alias{woods_plot}
\title{Wood's plot}
\usage{
woods_plot(
  data,
  fold_change,
  start_position,
  end_position,
  protein_length,
  coverage = NULL,
  protein_id = NULL,
  facet = NULL,
  colouring = NULL,
  fold_change_cutoff = 1
)
}
\arguments{
\item{data}{Data frame containing differential abundance, start and end peptide or precursor positions, protein
length and optionally a variable based on which peptides or precursors should be coloured.}

\item{fold_change}{Column in the data frame containing log2 fold changes.}

\item{start_position}{Column in the data frame containing the start positions for each peptide or precursor.}

\item{end_position}{Column in the data frame containing the end positions for each peptide or precursor.}

\item{protein_length}{Column in the data frame containing the length of the protein.}

\item{coverage}{Optional, column in the data frame containing coverage in percent. Will appear in the title of the barcode if provided.}

\item{protein_id}{Optional argument, column in the data frame containing protein identifiers. Required if only one protein
should be plotted and the data frame contains only information for this protein.}

\item{facet}{Optional argument, column in the data frame containing information by which data should be faceted. This can be
protein identifiers.}

\item{colouring}{Optional argument, column in the data frame containing information by which peptide or precursors should
be coloured.}

\item{fold_change_cutoff}{Optional argument specifying the log2 fold change cutoff used for assessing whether changes are significant. The default value is 2.}
}
\value{
A Wood's plot is returned. Plotting peptide or precursor fold changes accross protein sequence.
}
\description{
Creates a Wood's plot that plots log2 fold change of peptides or precursors along the protein sequence.
}
\examples{
\dontrun{
woods_plot(test,
  fold_change = diff,
  start_position = start,
  end_position = end,
  protein_length = length,
  colouring = pep_type,
  facet = pg_protein_accessions
)
}
}
