% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcm03extractProtFP.R
\name{extractProtFP}
\alias{extractProtFP}
\title{Amino Acid Properties Based Scales Descriptors (Protein Fingerprint)}
\usage{
extractProtFP(x, index = NULL, pc, lag, scale = TRUE, silent = TRUE)
}
\arguments{
\item{x}{A character vector, as the input protein sequence.}

\item{index}{Integer vector or character vector. Specify which AAindex
properties to select from the AAindex database by specify the
numerical or character index of the properties in the
AAindex database.
Default is \code{NULL}, means selecting all the AA properties
in the AAindex database.}

\item{pc}{Integer. Use the first pc principal components as the scales.
Must be no greater than the number of AA properties provided.}

\item{lag}{The lag parameter. Must be less than the amino acids.}

\item{scale}{Logical. Should we auto-scale the property matrix
before PCA? Default is \code{TRUE}.}

\item{silent}{Logical. Whether we print the standard deviation,
proportion of variance and the cumulative proportion of
the selected principal components or not.
Default is \code{TRUE}.}
}
\value{
A length \code{lag * p^2} named vector,
        \code{p} is the number of scales (principal components) selected.
}
\description{
Amino Acid Properties Based Scales Descriptors (Protein Fingerprint)
}
\details{
This function calculates amino acid properties based scales descriptors
(protein fingerprint). Users could specify which AAindex properties to
select from the AAindex database by specify the numerical or character
index of the properties in the AAindex database.
}
\examples{
x = readFASTA(system.file('protseq/P00750.fasta', package = 'protr'))[[1]]
fp = extractProtFP(x, index = c(160:165, 258:296), pc = 5, lag = 7, silent = FALSE)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}
\keyword{AAindex}
\keyword{extract}
\keyword{scales}

