% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_nircal.R
\name{read_nircal}
\alias{read_nircal}
\title{Import BUCHI NIRCal files}
\usage{
read_nircal(file, response = TRUE, spectra = TRUE,
            metadata = TRUE, progress = TRUE, verbose = TRUE)
}
\arguments{
\item{file}{the name of the NIRCal (.nir) file which the data are to be read
from. For URLs a temporary file is first downloaded and is then read.}

\item{response}{a logical indicating if the data of the response variables
must be returned (default is \code{TRUE}).}

\item{spectra}{a logical indicating if the spectral data must be returned
(default is \code{TRUE}).}

\item{metadata}{a logical indicating if the metadada must be returned
(default is \code{TRUE}).}

\item{progress}{a logical indicating if a progress bar must be printed
(default is \code{TRUE}).}

\item{verbose}{a logical indicating if the number of spectra and response
variables (an also the ID's of the spectra without gain and/or temperature
information) must be printed (default is \code{TRUE}).}
}
\value{
a data.frame containing the metadata, response variables (if
\code{response = TRUE}) and spectra (if \code{spectra = TRUE}, embedded in the
\code{data.frame} as a matrix named \code{...$spc}).
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}

This function imports .nir files generated by BUCHI NIRCal software.
}
\details{
The extension of the BUCHI NIRCal files is .nir. These files are used to
store spectra generated by BUCHI N-500 and BUCHI NIRMaster FT-NIR sensors.
See
\href{https://assets.buchi.com/image/upload/v1605790933/pdf/Technical-Datasheet/TDS_11593569_NIRCal.pdf}{NIRCal technical data sheet.}
}
\author{
\href{https://orcid.org/0000-0002-5369-5120}{Leonardo Ramirez-Lopez}
}
