# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Resample to given band position and fwhm
#' @description
#' Resample, written in C++
#' @param X matrix to resample
#' @param wav a numeric \code{vector} giving the original band positions
#' @param new_wav a numeric \code{vector} giving the new band positions
#' @param fwhm numeric \code{vector} giving the full width half maximums of the new band positions.
#' @keywords internal
#' @useDynLib prospectr
ResampleCppM <- function(X, wav, new_wav, fwhm) {
    .Call('_prospectr_ResampleCppM', PACKAGE = 'prospectr', X, wav, new_wav, fwhm)
}

ResampleCppV <- function(X, wav, new_wav, fwhm) {
    .Call('_prospectr_ResampleCppV', PACKAGE = 'prospectr', X, wav, new_wav, fwhm)
}

#' @title bitwise operations 
#' @description
#' bitwise operations  in C++
#' @param a integer 
#' @param b integer
#' @keywords internal
#' @useDynLib prospectr
bitAND <- function(aa, bb) {
    .Call('_prospectr_bitAND', PACKAGE = 'prospectr', aa, bb)
}

bitSR <- function(a, b) {
    .Call('_prospectr_bitSR', PACKAGE = 'prospectr', a, b)
}

#' @title Convolve 
#' @description
#' Convolution, written in C++
#' @param X matrix to convolve
#' @param f filter
#' @keywords internal
#' @useDynLib prospectr
convCppM <- function(X, f) {
    .Call('_prospectr_convCppM', PACKAGE = 'prospectr', X, f)
}

convCppV <- function(X, f) {
    .Call('_prospectr_convCppV', PACKAGE = 'prospectr', X, f)
}

#' @title A fast distance algorithm for two matrices written in C++ 
#' @usage 
#' fastDist(X,Y,method)
#' @param X a \code{matrix}
#' @param Y a \code{matrix}
#' @param method a \code{string} with possible values "euclid", "cor", "cosine"
#' @return a distance \code{matrix}
#' @keywords internal
#' @useDynLib prospectr
#' @author Antoine Stevens and Leonardo Ramirez-Lopez
fastDist <- function(X, Y, method) {
    .Call('_prospectr_fastDist', PACKAGE = 'prospectr', X, Y, method)
}

#' @title A fast distance algorithm for a matrix and a vector written in C++ 
#' @usage 
#' fastDistV(X,Y,method)
#' @param X a \code{matrix}
#' @param Y a \code{vector}
#' @param method a \code{string} with possible values "euclid", "cor", "cosine"
#' @return a distance \code{vector}
#' @author Antoine Stevens and Leonardo Ramirez-Lopez
#' @keywords internal 
#' @useDynLib prospectr
fastDistV <- function(X, Y, method) {
    .Call('_prospectr_fastDistV', PACKAGE = 'prospectr', X, Y, method)
}

residLm <- function(Yr, Xr) {
    .Call('_prospectr_residLm', PACKAGE = 'prospectr', Yr, Xr)
}

