% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/propr.R
\docType{methods}
\name{proportionality}
\alias{proportionality}
\alias{initialize,propr-method}
\alias{phit}
\alias{perb}
\alias{phis}
\alias{corr}
\title{Calculate Proportionality}
\usage{
\S4method{initialize}{propr}(.Object, counts, ivar, select)

phit(counts, ivar = 0, select, symmetrize = TRUE)

perb(counts, ivar = 0, select)

phis(counts, ivar = 0, select)

corr(counts, ivar = 0, select)
}
\arguments{
\item{.Object}{Missing. Ignore. Leftover from the generic
method definition.}

\item{counts}{A data.frame or matrix. A "count matrix" with
subjects as rows and features as columns.}

\item{ivar}{A numeric scalar. Specifies reference feature(s)
for additive log-ratio transformation. The argument will also
accept feature name(s) instead of the index position(s).
Set to "iqlr" to use inter-quartile log-ratio transformation.
Ignore to use centered log-ratio transformation.}

\item{select}{Subsets via \code{object@counts[, select]}.
Optional. Use this argument to subset the proportionality
matrix before building without altering the final result.}

\item{symmetrize}{A logical. If \code{TRUE}, forces symmetry
by reflecting the "lower left triangle".}
}
\value{
Returns a \code{propr} object.
}
\description{
Let D represent any number of features measured across N biological replicates
	exposed to a binary or continuous event E. For example, E could indicate case-control
	status, treatment status, treatment dose, or time. This function converts a "count matrix"
	with N rows and D columns into a proportionality matrix of D rows and D columns.

For phi, the result of \code{phit}, one can think of the resultant matrix as
	analogous to a distance matrix, except that it has no symmetry unless forced.
	For rho, the result of \code{perb}, one can think of the resultant matrix as
	analogous to a correlation matrix.
	For phs, the result of \code{phis}, one can think of the resultant matrix as
	either a naturally symmetric variant of phi or a monotonic variant of rho.
	Another function, \code{corr}, calculates Pearsons' correlation using
	log-ratio transformed data.

These methods all use the centered log-ratio transformation by default,
 but will use an additive log-ratio transformation instead if a scalar
 \code{ivar} is provided. When using an additive log-ratio transformation,
 this function will return \code{rho = 0} for the column and row in the
 \code{@matrix} slot that would contain the reference feature.
 Setting \code{ivar} to a numeric or character vector will transform
 data using the geometric mean of only the indexed features.
 Alternatively, setting \code{ivar} to "iqlr" will transform data using
 the geometric mean of only the features with variances that fall in
 the inter-quartile range of all per-feature variances. We base this
 "iqlr" transformation on the \code{ALDEx2} package.

Log-ratio transformation, by its nature, fails if the input data
 contain any zero values. To avoid an error in this case, these
 methods automatically replace all zero values with 1. However,
 the topic of zero replacement is controversial. Proceed carefully
 when analyzing data that contain any zero values.

The \code{select} argument subsets the feature matrix
 after log-ratio transformation but before calculating
 proportionality. This reduces the run-time and RAM
 overhead without impacting the final result. Removing
 lowly abundant features prior to log-ratio transformation
 could otherwise change the proportionality measure.
}
\examples{
library(propr)
data(mail)
phi <- phit(mail)
rho <- perb(mail)
phs <- phis(mail)
}
