% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{as.matrix.projection}
\alias{as.matrix.projection}
\title{Extract projected parameter draws and coerce to matrix}
\usage{
\method{as.matrix}{projection}(x, nm_scheme = "auto", allow_nonconst_wdraws_prj = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{projection} (returned by \code{\link[=project]{project()}}, possibly
as elements of a \code{list}).}

\item{nm_scheme}{The naming scheme for the columns of the output matrix.
Either \code{"auto"}, \code{"rstanarm"}, or \code{"brms"}, where \code{"auto"} chooses
\code{"rstanarm"} or \code{"brms"} based on the class of the reference model fit (and
uses \code{"rstanarm"} if the reference model fit is of an unknown class).}

\item{allow_nonconst_wdraws_prj}{A single logical value indicating whether to
allow projected draws with different (i.e., nonconstant) weights (\code{TRUE})
or not (\code{FALSE}). \strong{CAUTION}: Expert use only because if set to \code{TRUE},
the weights of the projected draws are stored in an attribute \code{wdraws_prj}
and handling this attribute requires special care (e.g., when subsetting
the returned matrix).}

\item{...}{Currently ignored.}
}
\value{
An \eqn{S_{\mathrm{prj}} \times Q}{S_prj x Q} matrix of projected
draws, with \eqn{S_{\mathrm{prj}}}{S_prj} denoting the number of projected
draws and \eqn{Q} the number of parameters. If \code{allow_nonconst_wdraws_prj}
is set to \code{TRUE}, the weights of the projected draws are stored in an
attribute \code{wdraws_prj}. (If \code{allow_nonconst_wdraws_prj} is \code{FALSE},
projected draws with nonconstant weights cause an error.)
}
\description{
This is the \code{\link[=as.matrix]{as.matrix()}} method for \code{projection} objects (returned by
\code{\link[=project]{project()}}, possibly as elements of a \code{list}). It extracts the projected
parameter draws and returns them as a matrix. In case of different (i.e.,
nonconstant) weights for the projected draws, see
\code{\link[=as_draws_matrix.projection]{as_draws_matrix.projection()}} for a better solution.
}
\details{
In case of the augmented-data projection for a multilevel submodel
of a \code{\link[brms:brmsfamily]{brms::categorical()}} reference model, the multilevel parameters (and
therefore also their names) slightly differ from those in the \pkg{brms}
reference model fit (see section "Augmented-data projection" in
\code{\link[=extend_family]{extend_family()}}'s documentation).
}
\examples{
\dontshow{if (requireNamespace("rstanarm", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Data:
dat_gauss <- data.frame(y = df_gaussian$y, df_gaussian$x)

# The "stanreg" fit which will be used as the reference model (with small
# values for `chains` and `iter`, but only for technical reasons in this
# example; this is not recommended in general):
fit <- rstanarm::stan_glm(
  y ~ X1 + X2 + X3 + X4 + X5, family = gaussian(), data = dat_gauss,
  QR = TRUE, chains = 2, iter = 500, refresh = 0, seed = 9876
)

# Projection onto an arbitrary combination of predictor terms (with a small
# value for `ndraws`, but only for the sake of speed in this example; this
# is not recommended in general):
prj <- project(fit, solution_terms = c("X1", "X3", "X5"), ndraws = 21,
               seed = 9182)

# Applying the as.matrix() generic to the output of project() dispatches to
# the projpred::as.matrix.projection() method:
prj_mat <- as.matrix(prj)

# Since the draws have all the same weight here, we can treat them like
# ordinary MCMC draws, e.g., we can summarize them using the `posterior`
# package:
if (requireNamespace("posterior", quietly = TRUE)) {
  print(posterior::summarize_draws(
    posterior::as_draws_matrix(prj_mat),
    "median", "mad", function(x) quantile(x, probs = c(0.025, 0.975))
  ))
}
# Or visualize them using the `bayesplot` package:
if (requireNamespace("bayesplot", quietly = TRUE)) {
  print(bayesplot::mcmc_intervals(prj_mat))
}
\dontshow{\}) # examplesIf}
}
