% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condPlotCat.R
\name{condPlotCat}
\alias{condPlotCat}
\title{Make conditional effect plot with data including a categorical variable}
\usage{
condPlotCat(
  labels = list(),
  yvar = "Y",
  total = FALSE,
  data,
  addvars = TRUE,
  mode = 1,
  rangemode = 2,
  maxylev = 6,
  catlabels = NULL,
  add.slopelabel = FALSE,
  xpos = 0.5,
  add.point = TRUE,
  add.vlines = TRUE,
  add.vlines.text = TRUE,
  add.anova = TRUE,
  ypos = NULL,
  add.arrow = TRUE,
  xinterval = NULL,
  hjust1 = NULL,
  hjust2 = NULL,
  ypos2 = NULL,
  ypos3 = NULL,
  ceno = 1
)
}
\arguments{
\item{labels}{Named list of variables}

\item{yvar}{character. "Y"(default) or "M"}

\item{total}{logical. If true, model include mediator variable.}

\item{data}{A data.frame}

\item{addvars}{logical}

\item{mode}{Numeric. One of 1:4. 1= simple indicator coding, 2= sequential coding, 3= Helmert coding, 4= effect coding}

\item{rangemode}{rangemode. 1 or 2.}

\item{maxylev}{maximal unique length of categorical variable}

\item{catlabels}{optional string of labels for the categorical variable}

\item{add.slopelabel}{logical}

\item{xpos}{numeric. x position of slope labels}

\item{add.point}{logical. If true, add point to the plot}

\item{add.vlines}{logical. If true, add vlines to the plot}

\item{add.vlines.text}{logical. If true, add vlines.text to the plot}

\item{add.anova}{logical. If true, add results of ANOVA to the plot}

\item{ypos}{optional. Y position of anova results}

\item{add.arrow}{logical. If true, add conditional effects to the plot}

\item{xinterval}{Integer. Width of angled arrow}

\item{hjust1}{optional. hjust of conditional effects 1}

\item{hjust2}{optional. hjust of conditional effects 2}

\item{ypos2}{optional. Y position of conditional effects 1}

\item{ypos3}{optional. Y position of conditional effects 2}

\item{ceno}{integer. 1 or 2}
}
\description{
Make conditional effect plot with data including a categorical variable
}
\examples{
\donttest{
library(ggplot2)
labels=list(X="protest",W="sexism",M="respappr",Y="liking")
catlabels=c("No protest","Individual protest","Collective protest")
catlabels2=c("No protest","Individual protest","Collective protest","Any protest")
condPlotCat(labels=labels,yvar="M",data=protest,mode=3,ypos=c(0.2,0.15,0.1))
condPlotCat(labels=labels,yvar="M",data=protest,mode=3,ceno=c(1,2),add.vlines.text=FALSE)
condPlotCat(labels=labels,catlabels=catlabels,yvar="M",data=protest,mode=3,
     add.arrow=FALSE,addvars=FALSE)
condPlotCat(labels=labels,yvar="M",data=protest,mode=3,catlabels=catlabels2,ceno=c(1,2))
condPlotCat(labels=labels,data=protest,catlabels=catlabels,add.slopelabel=TRUE,
     xpos=c(0.3,0.7,0.7),add.point=FALSE,add.vlines=FALSE,add.anova=FALSE,add.arrow=FALSE)
condPlotCat(labels=labels,data=protest,catlabels=catlabels,add.anova=FALSE,add.arrow=FALSE)
condPlotCat(labels=labels,data=protest,catlabels=catlabels,add.anova=FALSE)+xlim(c(3.5,6.5))
condPlotCat(labels=labels,data=protest,add.anova=TRUE,ypos=c(0.2,0.2,0.5),add.arrow=FALSE)
condPlotCat(labels=labels,data=protest,catlabels=catlabels,add.anova=FALSE,ceno=1)
condPlotCat(labels=labels,data=protest,catlabels=catlabels,add.anova=FALSE,ceno=2)
condPlotCat(labels=labels,data=protest,total=TRUE,catlabels=catlabels,ypos=0.1,
      add.arrow=FALSE)+xlim(c(4,6))
condPlotCat(labels=labels,data=protest,total=TRUE,catlabels=catlabels2,add.anova=FALSE,
      ceno=c(1,2),xinterval=0.05,hjust1=c(-0.05,-0.05,1.05),hjust2=c(-0.05,1.05,1.05),
      ypos2=c(0.5,0.1,0.3),ypos3=c(0.2,0.4,0.4),mode=3)+xlim(c(4,6))
}
}
