% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal-estimate-logistic.R
\name{cal_estimate_logistic}
\alias{cal_estimate_logistic}
\alias{cal_estimate_logistic.data.frame}
\alias{cal_estimate_logistic.tune_results}
\alias{cal_estimate_logistic.grouped_df}
\title{Uses a logistic regression model to calibrate probabilities}
\usage{
cal_estimate_logistic(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred_"),
  smooth = TRUE,
  parameters = NULL,
  ...
)

\method{cal_estimate_logistic}{data.frame}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred_"),
  smooth = TRUE,
  parameters = NULL,
  ...,
  .by = NULL
)

\method{cal_estimate_logistic}{tune_results}(
  .data,
  truth = NULL,
  estimate = dplyr::starts_with(".pred_"),
  smooth = TRUE,
  parameters = NULL,
  ...
)

\method{cal_estimate_logistic}{grouped_df}(
  .data,
  truth = NULL,
  estimate = NULL,
  smooth = TRUE,
  parameters = NULL,
  ...
)
}
\arguments{
\item{.data}{An ungrouped \code{data.frame} object, or \code{tune_results} object,
that contains predictions and probability columns.}

\item{truth}{The column identifier for the true class results
(that is a factor). This should be an unquoted column name.}

\item{estimate}{A vector of column identifiers, or one of \code{dplyr} selector
functions to choose which variables contains the class probabilities. It
defaults to the prefix used by tidymodels (\code{.pred_}). The order of the
identifiers will be considered the same as the order of the levels of the
\code{truth} variable.}

\item{smooth}{Applies to the logistic models. It switches between logistic
spline when \code{TRUE}, and simple logistic regression when \code{FALSE}.}

\item{parameters}{(Optional)  An optional tibble of tuning parameter values
that can be used to filter the predicted values before processing. Applies
only to \code{tune_results} objects.}

\item{...}{Additional arguments passed to the models or routines used to
calculate the new probabilities.}

\item{.by}{The column identifier for the grouping variable. This should be
a single unquoted column name that selects a qualitative variable for
grouping. Default to \code{NULL}. When \code{.by = NULL} no grouping will take place.}
}
\description{
Uses a logistic regression model to calibrate probabilities
}
\details{
This function uses existing modeling functions from other packages to create
the calibration:
\itemize{
\item \code{\link[stats:glm]{stats::glm()}} is used when \code{smooth} is set to \code{FALSE}
\item \code{\link[mgcv:gam]{mgcv::gam()}} is used when \code{smooth} is set to \code{TRUE}
}
\subsection{Multiclass Extension}{

This method has \emph{not} been extended to multiclass outcomes. However, the
natural multiclass extension is \code{\link[=cal_estimate_multinomial]{cal_estimate_multinomial()}}.
}
}
\examples{
# It will automatically identify the probability columns
# if passed a model fitted with tidymodels
cal_estimate_logistic(segment_logistic, Class)

# Specify the variable names in a vector of unquoted names
cal_estimate_logistic(segment_logistic, Class, c(.pred_poor, .pred_good))

# dplyr selector functions are also supported
cal_estimate_logistic(segment_logistic, Class, dplyr::starts_with(".pred_"))
}
\seealso{
\url{https://www.tidymodels.org/learn/models/calibration/},
\code{\link[=cal_validate_logistic]{cal_validate_logistic()}}
}
