% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.prioritylasso.R
\name{predict.prioritylasso}
\alias{predict.prioritylasso}
\title{Predictions from prioritylasso}
\usage{
\method{predict}{prioritylasso}(object, newdata, type = c("link", "response"),
  ...)
}
\arguments{
\item{object}{An object of class \code{prioritylasso}.}

\item{newdata}{(nnew \code{x} p) matrix or data frame with new values.}

\item{type}{Specifies the type of predictions. \code{link} gives the linear predictors for all types of response and \code{response} gives the fitted values.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Predictions that depend on \code{type}.
}
\description{
Makes predictions for a \code{prioritylasso} object. It can be chosen between linear predictors or fitted values.
}
\examples{
pl_bin <- prioritylasso(X = matrix(rnorm(50*500),50,500), Y = rbinom(50,1,0.5),
                       family = "binomial", type.measure = "auc",
                       blocks = list(block1=1:13,block2=14:200, block3=201:500),
                       block1.penalization = TRUE, lambda.type = "lambda.min",
                       standardize = FALSE, nfolds = 5)

newdata_bin <- matrix(rnorm(30*500),30,500)

predict(object = pl_bin, newdata = newdata_bin, type = "response")
}
\seealso{
\code{\link[prioritylasso]{pl_data}}, \code{\link[prioritylasso]{prioritylasso}}
}
\author{
Simon Klau
}
