% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_loglinear_targets.R
\docType{methods}
\name{add_loglinear_targets}
\alias{add_loglinear_targets}
\alias{add_loglinear_targets}
\title{Add Loglinear Targets}
\usage{
add_loglinear_targets(x, lower_bound_amount, lower_bound_target,
  upper_bound_amount, upper_bound_target)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{lower_bound_amount}{\code{numeric} lower bound for the total amount
of the features.}

\item{lower_bound_target}{\code{numeric} relative target that should be
 applied to features with a total amount that is less
than or equal to \code{lower_bound_amount}.}

\item{upper_bound_amount}{\code{numeric} upper bound for the total amount
of features.}

\item{upper_bound_target}{\code{numeric} relative target that should be
applied to features with a total amount that is greater
than or equal to \code{upper_bound_amount}.}

\item{...}{not used.}
}
\value{
\code{\link{ConservationProblem-class}} object with the target added
  to it.
}
\description{
Set targets as a proportion (between 0 and 1) and calculated using a
log-linear  equation and four tuning parameters (as used in Rodrigues
\emph{et al.} 2004). The first tuning parameter specifies the first cut-off
range size, and the second specifies  the second cut-off range size, the
third argument specifies the target required  for species with a range size
equal to or less than the first cut-off range size,  and the fourth argument
specifies the target required for species with a range size equal to or
greater than the required range size.
}
\details{
Note that with the exception of the maximum cover problem, targets must
be added to a \code{\link{problem}} or solving will return an error.


Targets are used to specify the minimum amount or proportion of a feature's
distribution that needs to be protected. All conservation planning problems
require adding targets with the exception of the maximum cover problem
(see \code{\link{add_max_cover_objective}}), which maximizes all features
in the solution and therefore does not require targets.
}
\examples{
# load data
data(sim_pu_raster, sim_features)

# create problem using loglinear targets
p <- problem(sim_pu_raster, sim_features) \%>\%
     add_min_set_objective() \%>\%
     add_loglinear_targets(10, 0.9, 100, 0.2) \%>\%
     add_binary_decisions()
\donttest{
# solve problem
s <- solve(p)

# plot solution
plot(s, main = "solution", axes = FALSE, box = FALSE)
}

}
\references{
Rodrigues ASL, Akcakaya HR, Andelman SJ, Bakarr MI, Boitani L, Brooks TM,
Chanson JS, Fishpool LDC, da Fonseca GAB, Gaston KJ, and others (2004)
Global gap analysis: priority regions for expanding the global
protected-area network. \emph{BioScience}, 54: 1092--1100.
}
\seealso{
\code{\link{targets}}.
}
