% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPerformance.R
\name{getPerformance}
\alias{getPerformance}
\title{Extract general information about solution}
\usage{
getPerformance(x)
}
\arguments{
\item{x}{\linkS4class{solution} or \linkS4class{portfolio} object.}
}
\value{
\link{data.frame}.
}
\description{
Provides general information about the process of solving.
}
\details{
\code{getPerformance()} function returns five specific fields:
\enumerate{
\item \strong{solution_name}: indicates the name of the solution, by default is \emph{sol}.
\item \strong{objective_value}: indicates the value of the objective function of a given solution.
This value depends on the type of model solved (more information in the \code{problem()} function).
\item \strong{gap}: returns the relative MIP optimality gap of a solution. It is measured as
the ratio between the objective function induced by the best known (primal solution)
integer solution and the objective function induced by the best node in the search
tree (dual solution).
\item \strong{solving_time}: indicates the solving time of mathematical model.
\item \strong{status}: provides the status of solver at the end of the optimization period.
This can have six states:
}
\itemize{
\item \emph{Optimal solution (according to gap tolerance)} : When the resolution of the model stop when
the quality of the solution (gap) is less than or equal to gap_limit (parameter of the \code{solve()} function).
\item \emph{No solution (model was proven to be infeasible or unbounded)}: When the model is infeasible.
\item \emph{Feasible solution (according to time limit)}: When the resolution of the model stops when a
time_limit has been reached finding a feasible solution (parameter of the \code{solve()} function).
\item \emph{No solution (according to time limit)}: When the resolution of the model stops when a time_limit
has been reached without finding a feasible solution (parameter of the \code{solve()} function).
\item \emph{First feasible solution}: When the resolution of the model stops when it has found the first
feasible solution (solution_limit = TRUE parameter in \code{solve()} function).
\item \emph{No solution information is available}: For any other case.
}
}
\examples{
\donttest{
# set seed for reproducibility
set.seed(14)

## Load data
data(sim_pu_data, sim_features_data, sim_dist_features_data,
sim_threats_data, sim_dist_threats_data, sim_sensitivity_data,
sim_boundary_data)

## Create data instance
problem_data <- inputData(
  pu = sim_pu_data, features = sim_features_data, dist_features = sim_dist_features_data,
  threats = sim_threats_data, dist_threats = sim_dist_threats_data,
  sensitivity = sim_sensitivity_data, boundary = sim_boundary_data
)

## Create optimization model
problem_model <- problem(x = problem_data, blm = 1)

## Solve the optimization model
s <- solve(a = problem_model, time_limit = 2, output_file = FALSE, cores = 2)

# get solution gap
getPerformance(s)
}

}
