% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterResults.R
\name{seq_lengths}
\alias{seq_lengths}
\title{Get a summary of sequence lengths from a primerTree object}
\usage{
seq_lengths(x, summarize = TRUE)
}
\arguments{
\item{x}{a primerTree object.}

\item{summarize}{a logical indicating if a summary should be displayed}
}
\value{
a table of sequence length frequencies
}
\description{
Get a summary of sequence lengths from a primerTree object
}
\examples{

# Show the counts for each length
seq_lengths(mammals_16S)

# Plot the distribution of lengths
seqLengths <- seq_lengths(mammals_16S)
barplot(seqLengths, 
 main = "Frequency of sequence lengths for 16S mammal primers", 
 xlab="Amplicon length (in bp)", 
 ylab=("Frequency"))
}

