% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{check_if_positive}
\alias{check_if_positive}
\title{Check If Positive}
\usage{
check_if_positive(
  x,
  allow_na = TRUE,
  arg = rlang::caller_arg(x),
  call = rlang::caller_env()
)
}
\arguments{
\item{x}{Input variable to check if it is positive number}

\item{allow_na}{Input boolean to determine if \code{NA} or \code{NaN} is allowed.
Default: \code{TRUE}}

\item{arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
The variable itself or an error message if variable is not positive
}
\description{
Check if the input variable is a positive number
}
\seealso{
\code{\link[rlang]{caller_arg}}, \code{\link[rlang]{stack}}
 \code{\link[cli]{cli_abort}}
}
